#include "find6.h"


void flushin(FILE *stream);

void transl_f2c(char *str, int size);
void transl_c2f(char *str, int size);

void create_file(char *file);
void file_exists(char *file);

void exit_program(int x);

boolean symbol (char c);
boolean sign(char c);
boolean letter(char c);
boolean number(char c);

void tolow_c (char *s);
void tolow_f (char *s);

int getquot(FILE *fp, char *quot);
void readQuot(char *quot);

void add_entry(char* quot, char* name);
void add_entries();

void create_list(char* s, char op2);
void list_entries();

quote find_entry(char *s, int entry_x, char op2);
void lookfor_entry();

void delete_entry(char *quote, char *name);
void erase_entry();

void alter_addentry();
void alter_entry();

void add_entryH(char *file, char* quot, char* name);
void delete_entryH(char *file, char* quote, char* name);

void list_changes(char *fi);
void list_hist();

void show_list(char *file);

quote find_entryH(char *file, int entry);

void recov_quot();
void del_quot();

void history();

void make_copy();
void recover_copy();

void mem_check();
void about_author();

int menu();
int menu2();

void flushin(FILE *stream)
{
  int c;

  while ((c = fgetc(stream))!=EOF && c!='\n');
}

void transl_f2c(char *str, int size)
{
	int i;
	
	for(i=0; i<size && str[i]!='\0'; i++)
	{
		switch(str[i])
		{
			case '': 
				str[i]='\xA0';
				break;
				
			case '': 
				str[i]='\x85';
				break;
				
			case '':
				str[i]='\xC6';
				break;
				
			case '':
				str[i]='\x83';
				break;
				
			case '':
				str[i]='\x87';
				break;
				
			case '':
				str[i]='\x80';
				break;
				
			case '':
				str[i]='\x82';
				break;
				
			case '':
				str[i]='\x8A';
				break;
				
			case '':
				str[i]='\x88';
				break;
				
			case '':
				str[i]='\xA1';
				break;
				
			case '':
				str[i]='\x8D';
				break;
				
			case '':
				str[i]='\x8C';
				break;
				
			case '':
				str[i]='\xA2';
				break;
				
			case '':
				str[i]='\x95';
				break;
				
			case '':
				str[i]='\xE4';
				break;
				
			case '':
				str[i]='\x93';
				break;
				
			case '':
				str[i]='\xA3';
				break;
				
			case '':
				str[i]='\x97';
				break;
			
			case '':
				str[i]='\x96';
				break;
				
			case '':
				str[i]='\xB5';
				break;
				
			case '':
				str[i]='\xB7';
				break;
				
			case '':
				str[i]='\x90';
				break;
				
			case '':
				str[i]='\xD4';
				break;
				
			case '':
				str[i]='\xB6';
				break;
				
			case '':
				str[i]='\xD2';
				break;
				
			case '':
				str[i]='\xD6';
				break;
				
			case '':
				str[i]='\xDE';
				break;
				
			case '':
				str[i]='\xD7';
				break;
				
			case '':
				str[i]='\xE0';
				break;
				
			case '':
				str[i]='\xE3';
				break;
				
			case '':
				str[i]='\xE5';
				break;			
				
			case '':
				str[i]='\xE2';
				break;
				
			case '':
				str[i]='\xE9';
				break;
				
			case '':
				str[i]='\xEB';
				break;
				
			case '':
				str[i]='\xEA';
				break;
					
		}
	}	
}

void transl_c2f(char *str, int size)
{
	int i;
	
	for(i=0; i<size && str[i]!='\0'; i++)
	{
		switch(str[i])
		{
			case '\xA0': 
				str[i]='';
				break;
				
			case '\x85': 
				str[i]='';
				break;
				
			case '\xC6':
				str[i]='';
				break;
				
			case '\x83':
				str[i]='';
				break;
				
			case '\x87':
				str[i]='';
				break;
				
			case '\x80':
				str[i]='';
				break;
				
			case '\x82':
				str[i]='';
				break;
				
			case '\x8A':
				str[i]='';
				break;
				
			case '\x88':
				str[i]='';
				break;
				
			case '\xA1':
				str[i]='';
				break;
				
			case '\x8D':
				str[i]='';
				break;
				
			case '\x8C':
				str[i]='';
				break;
				
			case '\xA2':
				str[i]='';
				break;
				
			case '\x95':
				str[i]='';
				break;
				
			case '\xE4':
				str[i]='';
				break;
				
			case '\x93':
				str[i]='';
				break;
				
			case '\xA3':
				str[i]='';
				break;
			
			case '\x97':
				str[i]='';
				break;
				
			case '\x96':
				str[i]='';
				break;
				
			case '\xB5':
				str[i]='';
				break;
				
			case '\xB7':
				str[i]='';
				break;
				
			case '\x90':
				str[i]='';
				break;
				
			case '\xD4':
				str[i]='';
				break;
				
			case '\xB6':
				str[i]='';
				break;
				
			case '\xD2':
				str[i]='';
				break;
				
			case '\xD6':
				str[i]='';
				break;
				
			case '\xDE':
				str[i]='';
				break;
				
			case '\xD7':
				str[i]='';
				break;
				
			case '\xE0':
				str[i]='';
				break;
				
			case '\xE3':
				str[i]='';
				break;
				
			case '\xE5':
				str[i]='';
				break;
				
			case '\xE2':
				str[i]='';
				break;
				
			case '\xE9':
				str[i]='';
				break;
				
			case '\xEB':
				str[i]='';
				break;
				
			case '\xEA':
				str[i]='';
				break;
					
		}
	}	
}

void create_file(char *file)
{
	FILE *fp;

	fp = fopen(file, "w");

	if(strcmp(file,FICH)==0)
		fprintf(fp, "-== Citaes ==-");

	fflush(fp);
	fclose(fp);
}

void file_exists(char *file)
{
	FILE *fp;
	
	if((fp = fopen(file, "r")) == NULL)
		create_file(file);
		
	fclose(fp);
}

void remove_tempcopy()
{
	FILE *fp;
	
	if((fp = fopen(TCOPY, "r")) != NULL)
	{
		fclose(fp);
	
		if(remove(TCOPY) != 0)
			printf("ERRO: Incapaz de remover o ficheiro de backup temporario");
	}		
}

void create_tempcopy()
{
	FILE *fpf, *fpd;
	int n;
	char str1[MAXQUOT], str2[MAXQUOT];
	
	fpf = fopen(FICH, "r");
	fpd = fopen(TCOPY, "w");
	
	fscanf(fpf, " %[^\n]", str1);
	fprintf(fpd, "%s", str1);
	
	while(getquot(fpf, str1)!=-1 && fscanf(fpf, " %[^\n]", str2)!=EOF)
	{
		fprintf(fpd, "\n\n%s\n", str1);
		fprintf(fpd, "%s", str2);
	}
		
	fflush(fpd);

	fclose(fpf);
	fclose(fpd);
}

void exit_program(int x)
{
	remove(ADDF);
	remove(DELF);

	if(x==0)
	{
		remove_tempcopy();
		create_tempcopy();
	}
		
	exit(x);
}

boolean symbol (char c)
{
	return(c == '/' || c == '-' || c == '(' || c == ')' || c == '[' || c == ']');
}

boolean sign(char c)
{
	return(c == ',' || c == ';' || c == ':' || c == '.' || c == '!' || c == '?' || c == '\'' || c == '' || c == ''); 
}

boolean letter(char c)
{
	return(('a'<=c && c<='z') || ('A'<=c && c <='Z') || c=='' || c=='' || c=='' || c=='' || c=='' || c=='' || c=='' || c=='' || c=='' || c=='' || c=='' || c=='' || c=='' || c=='' || c=='' || c=='' || c=='' || c=='' || c=='' || c =='' || c=='' || c=='' ||  c=='' || c=='' || c=='' || c=='' || c=='' || c=='' || c=='' || c=='' || c=='' || c=='' || c=='' || c=='' || c=='' || c=='');
}

boolean number(char c)
{
	return( c>='0' && c <='9'); 
}

void tolow_c (char *s)
{
	int i;
	
	for(i=0; s[i]!='\0'; i++)
	{
		switch(s[i])
		{
			case 'A':
				s[i]='a';
				break;
				
			case '\xB5': //caso 
				s[i]='\xA0';
				break;
				
			case '\xB7': //case 
				s[i]='\x85';
				break;
				
			case '\xB6': //case 
				s[i]='\x83';
				break;
				
			case '\xC7': //case 
				s[i]='\xC6';
				break;
				
			case 'B':
				s[i]='b';
				break;
				
			case 'C':
				s[i]='c';
				break;
				
			case 'D':
				s[i]='d';
				break;
				
			case 'E': 
				s[i]='e';
				break;
				
			case '\x90': //case 
				s[i]='\x82';
				break;	
					
			case '\xD4': //case 
				s[i]='\x88';
				break;
			
			case '\xD2': //case 
				s[i]='\x88';
				break;
				
			case 'F':
				s[i]='f';
				break;
				
			case 'G':
				s[i]='g';
				break;
				
			case 'H':
				s[i]='h';
				break;
				
			case 'I':
				s[i]='i';
				break;
				
			case '\xD6': //case 
				s[i]='\xA1';
				break;
				
			case '\xDE': //case 
				s[i]='\x8D';
				break;
				
			case '\xD7': //case 
				s[i]='\x8C';
				break;
				
			case 'J':
				s[i]='j';
				break;
				
			case 'K':
				s[i]='k';
				break;
				
			case 'L':
				s[i]='l';
				break;
				
			case 'M':
				s[i]='m';
				break;
				
			case 'N':
				s[i]='n';
				break;
				
			case 'O':
				s[i]='o';
				break;
				
			case '\xE0': //case 
				s[i]='\x95';
				break;
				
			case '\x95': //case 
				s[i]='\xA2';
				break;
				
			case '\xE2': //case 
				s[i]='\x93';
				break;
				
			case '\xE5': //case 
				s[i]='\xE4';
				break;
			
			case 'P':
				s[i]='p';
				break;
				
			case 'Q':
				s[i]='q';
				break;
				
			case 'R':
				s[i]='r';
				break;
				
			case 'S':
				s[i]='s';
				break;
				
			case 'T':
				s[i]='t';
				break;
				
			case 'U':
				s[i]='u';
				break;
			
			case '\xE9': //case  
				s[i]='\xA3';
				break;
				
			case '\xEB': //case 
				s[i]='\x97';
				break;
				
			case '\xEA': //case 
				s[i]='\x96';
				break;
				
			case 'V':
				s[i]='v';
				break;
				
			case 'X':
				s[i]='x';
				break;
				
			case 'Y':
				s[i]='y';
				break;
				
			case 'W':
				s[i]='w';
				break;
				
			case 'Z':
				s[i]='z';
				break;
				
			case '\x80': //case 
				s[i]='\x87';
				break;
		}
	}
}

void tolow_f (char *s)
{
		int i;
	
	for(i=0; s[i]!='\0'; i++)
	{
		switch(s[i])
		{
			case 'A':
				s[i]='a';
				break;
				
			case '': 
				s[i]='';
				break;
				
			case '': 
				s[i]='';
				break;
				
			case '':
				s[i]='';
				break;
				
			case '':
				s[i]='';
				break;
				
			case 'B':
				s[i]='b';
				break;
				
			case 'C':
				s[i]='c';
				break;
				
			case 'D':
				s[i]='d';
				break;
				
			case 'E': 
				s[i]='e';
				break;
				
			case '': 
				s[i]='';
				break;	
					
			case '':
				s[i]='';
				break;
			
			case '': 
				s[i]='';
				break;
				
			case 'F':
				s[i]='f';
				break;
				
			case 'G':
				s[i]='g';
				break;
				
			case 'H':
				s[i]='h';
				break;
				
			case 'I':
				s[i]='i';
				break;
				
			case '':
				s[i]='';
				break;
				
			case '':
				s[i]='';
				break;
				
			case '': 
				s[i]='';
				break;
				
			case 'J':
				s[i]='j';
				break;
				
			case 'K':
				s[i]='k';
				break;
				
			case 'L':
				s[i]='l';
				break;
				
			case 'M':
				s[i]='m';
				break;
				
			case 'N':
				s[i]='n';
				break;
				
			case 'O':
				s[i]='o';
				break;
				
			case '':
				s[i]='';
				break;
				
			case '':
				s[i]='';
				break;
				
			case '':
				s[i]='';
				break;
				
			case '':
				s[i]='';
				break;
			
			case 'P':
				s[i]='p';
				break;
				
			case 'Q':
				s[i]='q';
				break;
				
			case 'R':
				s[i]='r';
				break;
				
			case 'S':
				s[i]='s';
				break;
				
			case 'T':
				s[i]='t';
				break;
				
			case 'U':
				s[i]='u';
				break;
			
			case '': 
				s[i]='';
				break;
				
			case '': 
				s[i]='';
				break;
				
			case '': 
				s[i]='';
				break;
				
			case 'V':
				s[i]='v';
				break;
				
			case 'X':
				s[i]='x';
				break;
				
			case 'Y':
				s[i]='y';
				break;
				
			case 'W':
				s[i]='w';
				break;
				
			case 'Z':
				s[i]='z';
				break;
				
			case '': 
				s[i]='';
				break;
		}
	}
}

int getquot(FILE *fp, char *quot) //ler uma citao do ficheiro fp
{
	int i;
	char c;

	if((c = getc(fp))==EOF)
		return(-1);
		
	while(c == ' ' || c== '\n')
		c = getc(fp);
	
	if(c=='\"')
	{		
		i=0;		
		quot[i]=c;
		
		i++;
		
		c = getc(fp);
		
		while(letter(c) || sign(c) || symbol(c) || number(c) ||c == ' ' || c == '\n' || c == '\'' || c=='\t')
		{
		
			quot[i]=c;
			
/*			if(c=='\n')
			{	
				i++;
				quot[i]='\t';
				
				i++;
				quot[i]='\t';
			}	
*/	
			i++;
			
			c = getc(fp);
		}
		
		quot[i]='"';
		quot[i+1]='\0';
			
		return(1);
	}
	
	return(0);
}

void readQuot(char *quot) //ler uma citao do teclado
{
	char c, aux[MAXQUOT], auxie[2];
	
	c = getchar();
	quot[0]=c;
	quot[1] = '\0';
	
	scanf("%[^\"]", aux);
	
	scanf("%[^\n]", auxie);
	
	strcat(quot, aux);
	strcat(quot, auxie);
}

void add_entry(char* quot, char* name)
{
	FILE *fp;
	
	flushin(stdin);

	file_exists(FICH);
		
	if((fp = fopen(FICH, "a"))==NULL)
	{
		printf("Erro: Impossibilidade em abrir o ficheiro\n");
		exit_program(-1);
	}
			
	transl_c2f(quot, MAXQUOT);
	transl_c2f(name, MAXNAME);
			
	if(fprintf(fp, "\n%s\n%s\n", quot, name)==-1)
	{
		printf("Erro: A entrada n\xC6o foi adicionada.\n\n");
		exit_program(-1);
	}
/*	
	printf("\n\n0 Nadd: %d\nNdele: %d\n\n", Nadd, Ndele);
	getchar();
*/	
	add_entryH(ADDF, quot, name);
/*	
	printf("\n\n1 Nadd: %d\nNdele: %d\n\n", Nadd, Ndele);
	getchar();
*/	
	if(Ndele>0)
		delete_entryH(DELF, quot, name);
/*		
	printf("\n\n2 Nadd: %d\nNdele: %d\n\n", Nadd, Ndele);
	getchar();
*/			
	printf("\nEstado: Entrada adicionada com sucesso\n\n");
			
	fflush(fp);
	fclose(fp);

}

void add_entries()
{
	char quot[MAXQUOT], name[MAXNAME], op2;
	int op;

	ungetc('\n', stdin);
	
	do
	{
		flushin(stdin);
	
		printf("\n\nIntroduza cita\x87\xC6o: ");
		readQuot(quot);
		
		printf("\n\nIntroduza autor: ");
		scanf(" %[^\n]", name);
		
		system("cls");
		
		printf("\n\n\nDeseja adicionar a entrada?\n\n\tCita\x87\xC6o: %s\n\n\tAutor: %s\n\nOp\x87\xC6o (S/N): ", quot, name);
		scanf(" %c", &op2);
		
		if(op2=='S' || op2=='s')
			add_entry(quot, name);
			
		else
			printf("\nEstado: A entrada n\xC6o foi adicionada.\n\n");
			
		getchar();
	}
	while((op=menu2())==1);
	
	if(op==0)
		exit_program(0);
}

void create_list(char* s, char op2)
{
	char quot[MAXQUOT], name[MAXNAME], c, quot2[MAXQUOT], name2[MAXNAME];
	int n, val;
	FILE *fp;

	if(op2=='S' || op2=='s')
		tolow_c(s);
		
	flushin(stdin);
	
	if((fp = fopen(FICH, "r")) == NULL)
	{
		printf("Erro: Impossibilidade em abrir o ficheiro\n");
		exit_program(-1);
	}
	
	flushin(fp);
		
	printf("\n\n|======= Lista de resultados =======|");
	
	n = 0;
	
	while((val = getquot(fp, quot))!=-1)
	{		
		if(val != 0)
		{	
			fscanf(fp, " %[^\n]", name);
				
			transl_f2c(quot, MAXQUOT);
			transl_f2c(name, MAXNAME);
				
			if(op2=='S' || op2=='s')
			{
				strcpy(quot2, quot);
				strcpy(name2, name);
					
				tolow_c(quot2);
				tolow_c(name2);
					
				if(strstr (quot2, s) != NULL || strstr (name2, s) != NULL)
				{
					n++;
				  
					printf("\n\n\n%da Resultado:\n \tCita\x87\xC6o: %s\n\n \tAutor: %s\n\n\n", n, quot, name);
				  
					if(n%ENTRPTAB==0)
					{
						printf("\n\n\n\tPrima Enter para continuar...\n\n");
					
						getchar();
					}
				}
			}
				
			else
			{
				if(strstr (quot, s) != NULL || strstr (name, s) != NULL)
				{
					n++;
				  
					printf("\n\n\n%da Resultado:\n \tCita\x87\xC6o: %s\n\n \tAutor: %s\n\n\n", n, quot, name);
				  
					if(n%ENTRPTAB==0)
					{
						printf("\n\n\n\tPrima Enter para continuar...\n\n");
					
						getchar();
					}
				}
			}
		}

	}	
		
	if(n == 0)
		printf("\n\nN\xC6o h\xA0 resultados a mostrar.\n\n");

	else
		if(n == 1)
			printf("Houve 1 resultado.\n");
				
		else
			printf("\n\nHouveram %d resultados.\n", n);
			
	printf("_____________________________________\n\n");
		
	getchar();
		
	fclose(fp);
}

void list_entries()
{
	char s[MAXSTR], op2;
	int op;

	do
	{	
		printf("Procurar: ");
		scanf(" %[^\n]", s);
		
		printf("Sem distin\x87\xC6o de mai\xA3sculas e min\xA3sculas? (S/N) ");
		scanf(" %c", &op2);
		
		create_list(s, op2);
	} 
	while((op=menu2())==1);
	
	if(op==0)
		exit_program(0);
}

quote find_entry(char *s, int entry_x, char op2)
{
	char quot[MAXQUOT], name[MAXNAME], c, quot2[MAXQUOT], name2[MAXNAME];
	int n, val;
	FILE *fp;
	quote quo;
	
	file_exists(FICH);

	if(op2=='S' || op2=='s')
		tolow_c(s);
		
	flushin(stdin);
	
	if((fp = fopen(FICH, "r")) == NULL)
	{
		printf("Erro: Impossibilidade em abrir o ficheiro\n");
		exit_program(-1);
	}
	
	flushin(fp);
	
	n = 0;
	
	while((val = getquot(fp, quot))!=-1 && n<=entry_x)
	{		
		if(val != 0)
		{	
			fscanf(fp, " %[^\n]", name);
				
			transl_f2c(quot, MAXQUOT);
			transl_f2c(name, MAXNAME);
				
			if(op2=='S' || op2=='s')
			{
				strcpy(quot2, quot);
				strcpy(name2, name);
					
				tolow_c(quot2);
				tolow_c(name2);
					
				if(strstr (quot2, s) != NULL || strstr (name2, s) != NULL)
				{
					n++;
				  
					if(entry_x == n)
					{
						printf("\n\n\nResultado:\n \tCita\x87\xC6o: %s\n\n \tAutor: %s\n\n\n", quot, name);
						break;
					}
				}
			}
				
			else
			{
				if(strstr (quot, s) != NULL || strstr (name, s) != NULL)
				{
					n++;
				  
					if(entry_x == n)
					{
						printf("\n\n\nEntrada:\n \tCita\x87\xC6o: %s\n\n \tAutor: %s\n\n\n", quot, name);
						break;
					}	
				}
			}
		}

	}	
		
	if(n == 0)
	{
		quo.quot[0] = '\0';
		quo.name[0] = '\0';
	
		printf("\n\nN\xC6o h\xA0 entradas a mostrar.\n\n");
	}	
		
	else
	{
		strcpy(quo.quot, quot);
		strcpy(quo.name, name);
	}
			
	printf("_____________________________________\n\n");
		
	getchar();
		
	fclose(fp);
	
	return(quo);
}

void lookfor_entry()
{
	char s[MAXSTR], op2;
	int entry_x, op;

	do
	{	
		printf("Procurar: ");
		scanf(" %[^\n]", s);
		
		printf("N\xA3mero de entrada: ");
		scanf("%d", &entry_x);
		
		printf("Sem distin\x87\xC6o de mai\xA3sculas e min\xA3sculas? (S/N) ");
		scanf(" %c", &op2);
		
		find_entry(s, entry_x, op2);
	} 
	while((op=menu2())==1);
	
	if(op==0)
		exit_program(0);
}

void delete_entry(char *quote, char *name)
{
	char quot[MAXQUOT], nam[MAXNAME], opy, c;
	int val;
	FILE *fp, *fpt;
	fpos_t cut;
	boolean erased;
	
	file_exists(FICH);
	
	transl_c2f(quote, MAXQUOT);
	transl_c2f(name, MAXQUOT);
	
	flushin(stdin);

	if((fp = fopen(FICH, "r+")) == NULL)
	{
		printf("\nErro: Impossibilidade em abrir o ficheiro\n");
		exit_program(-1);
	}
		
	if((fpt=fopen(TEMP, "w+")) == NULL)
	{
		printf("\nErro: Impossibilidade em abrir o ficheiro\n");
		exit_program(-1);
	}
	
	flushin(fpt);
		
	fscanf(fp, " %[^\n]", quot);
	fprintf(fpt, "%s\n", quot);
		
	while((val = getquot(fp, quot))!=-1)
	{		
		if(val != 0)
		{				
			if((fscanf(fp, " %[^\n]", nam)!=0))
			{
				if((strcmp (quote, quot) != 0) || (strcmp (name, nam) !=0))
					fprintf(fpt, "\n%s\n%s\n", quot, nam);
							
				else 
					erased == TRUE;
				
			}	
		}
	}
	fflush(fp);	
	fclose(fp);
		
	fflush(fpt);
	fclose(fpt);
		
	if(remove(FICH)==0)
	{
		rename(TEMP, FICH);
		
		if(erased == FALSE)
			printf("\n\nErro: Entrada n\xC6o existe em mem\xA2ria.\n\n");
			
		else
		{
			printf("\n\nEntrada eliminada com sucesso.\n\n");
				
			add_entryH(DELF, quote, name);
			
			if(Nadd>0)
				delete_entryH(ADDF, quote, name);
		}
	}
			
	else
		printf("\n\nErro: O ficheiro %s n\xC6o pode ser alterado.\n\n", FICH); 
}

void erase_entry()
{
	char s[MAXSTR], op2, opy;
	int op, entry_x;
	quote quo;

	do
	{
		printf("Procurar: ");
		scanf(" %[^\n]", s);
		
		printf("N\xA3mero de entrada: ");
		scanf("%d", &entry_x);
		
		printf("\nSem distin\x87\xC6o de mai\xA3sculas e min\xA3sculas? (S/N) ");
		scanf(" %c", &op2);
		
		system("cls");
		
		quo = find_entry(s, entry_x, op2);
		
		if(quo.quot[0]!='\0')
		{
			printf("\n\nQuer realmente eliminar esta entrada? (S/N) ");
			scanf(" %c", &opy);
		
			if(opy=='s' || opy=='S')
				delete_entry(quo.quot, quo.name);
			
			else
				printf("A entrada n\xC6o foi eliminada.");
		
			getchar();
		}
	}
	while((op=menu2())==1);
	
	if(op==0)
		exit_program(0);
}

void alter_addentry()
{
	char quot[MAXQUOT], name[MAXNAME], op2;
	
	ungetc('\n', stdin);
	
	flushin(stdin);
	
	printf("\n\nIntroduza cita\x87\xC6o: ");
	readQuot(quot);
		
	printf("\n\nIntroduza autor: ");
	scanf(" %[^\n]", name);
		
	system("cls");
		
	printf("\n\n\nDeseja adicionar a entrada?\n\n\tCita\x87\xC6o: %s\n\n\tAutor: %s\n\nOp\x87\xC6o (S/N): ", quot, name);
	scanf(" %c", &op2);
		
	if(op2=='S' || op2=='s')
		add_entry(quot, name);
			
	else
		printf("\nEstado: A entrada n\xC6o foi adicionada.\n\n");
}

void alter_entry()
{
	char s[MAXSTR], quot[MAXQUOT], name[MAXNAME], op2, opy;
	int entry_x, op;
	quote quo;
	
	do
	{
		printf("Procurar: ");
		scanf(" %[^\n]", s);
		
		printf("N\xA3mero de entrada: ");
		scanf("%d", &entry_x);
		
		printf("\nSem distin\x87\xC6o de mai\xA3sculas e min\xA3sculas? (S/N) ");
		scanf(" %c", &op2);
		
		system("cls");
		
		quo = find_entry(s, entry_x, op2);
		
		printf("\n\nQuer realmente substituir esta entrada? (S/N) ");
		scanf(" %c", &opy);
		
		if(opy=='s' || opy=='S')
		{
			delete_entry(quo.quot, quo.name);
			
			printf("Adicionar nova entrada...\n\n");
			
			alter_addentry();
		}
		
		else
			printf("A entrada n\xC6o foi alterada.");
			
		getchar();
	}
	while((op=menu2())==1);
	
	if(op==0)
		exit_program(0);
}


void add_entryH(char *file, char* quot, char* name)
{
	FILE *fp;
	
	//flushin(stdin);

	file_exists(file);
		
	if((fp = fopen(file, "a"))==NULL)
	{
		printf("Erro: Impossibilidade em abrir o ficheiro\n");
		exit_program(-1);
	}
			
	if(fprintf(fp, "\n%s\n%s\n", quot, name)==-1)
	{
		printf("Erro: A entrada n\xC6o foi adicionada.\n\n");
		exit_program(-1);
	}
	
	else
		if(strcmp(file, ADDF)==0)
			Nadd++;
			
		else
			Ndele++;
			
	fflush(fp);
	fclose(fp);
}

void delete_entryH(char *file, char* quote, char* name)
{
	char quot[MAXQUOT], nam[MAXNAME], opy, c;
	int val;
	FILE *fp, *fpt;
	fpos_t cut;
	boolean erased = FALSE;
	
	file_exists(file);
	
	if((fp = fopen(file, "r+")) == NULL)
	{
		printf("\nErro: Impossibilidade em abrir o ficheiro\n");
		exit_program(-1);
	}
		
	if((fpt=fopen(TEMPH, "w+")) == NULL)
	{
		printf("\nErro: Impossibilidade em abrir o ficheiro\n");
		exit_program(-1);
	}
	
	flushin(fp);
	flushin(fpt);
		
	while((val = getquot(fp, quot))!=-1)
	{		
		if(val != 0)
		{				
			if((fscanf(fp, " %[^\n]", nam)!=0))
			{
			
//				printf("\n\nquote: %s\nquot: %s\n\nname: %s\nnam: %s\n\n", quote, quot, name, nam);
			
				if((strcmp (quote, quot) != 0) || (strcmp (name, nam) !=0))
					fprintf(fpt, "\n%s\n%s\n", quot, nam);
							
				else 
					erased = TRUE;	
			}	
		}
	}
	fflush(fp);	
	fclose(fp);
		
	fflush(fpt);
	fclose(fpt);
		
	if(remove(file)==0)
	{
		rename(TEMPH, file);
/*		
		if(erased == FALSE)
			printf("\n\nErro: Entrada n\xC6o existe em mem\xA2ria.\n\n");
*/		
		
		if(erased==TRUE)
		{
			//printf("\n\nEntrada eliminada com sucesso.\n\n");
			
			if(strcmp(file, ADDF)==0)
				Nadd--;
				
			else
				Ndele--;
		}
	}
			
	else
		printf("\n\nErro: O ficheiro %s n\xC6o pode ser alterado.\n\n", FICH); 
}

void list_changes(char *fi)
{
	FILE *fd;
	char quote[MAXQUOT], name[MAXNAME];
	int n;
	
	if((fd = fopen(fi, "r"))==NULL)
	{
		printf("\n\nErro: Impossibilidade em abrir o ficheiro %s\n", fi);
		getchar();
		exit_program(-1);
	}
	
	n=0;
	
	while(getquot(fd, quote)!=0)
	{
		if(fscanf(fd, " %[^\n]", name) != 0)
		{
			n++;
			
			transl_f2c(quote, MAXQUOT);
			transl_f2c(name, MAXNAME);
			
			printf("\n\n\t%d) \n\t\tEntrada: %s\n\t\tAutor: %s", n, quote, name);
			
			if(n%ENTRPTAB==0)
			{
				printf("\n\n\n\tPrima Enter para continuar...\n\n");
				
				getchar();
			}
		}
	}
	
	fclose(fd);
	
	if(n==1)
		printf("\n\nFoi listada 1 entrada.");
		
	else	
		printf("\n\nForam listadas %d entradas.", n);
}


void list_hist()
{
	printf("\n\tHist\xA2ria da sess\xC6o actual");
	
	if(Nadd==0 && Ndele==0)
		printf("\n\n\nN\xC6o existe nada a reportar...");
		
	else
	{
		if(Nadd!=0)
		{
			printf("\n\n\n\nEntradas adicionadas...");
			list_changes(ADDF); 
		}
		
		if(Nadd!=0 && Ndele!=0)
		{
			printf("\n");
			getchar();		
			system("cls");
		}
	
		if(Ndele!=0)
		{
			printf("\n\nEntradas eliminadas...");
			list_changes(DELF);
		}
	
	}
	printf("\n");
		
	getchar();
}

void show_list(char *file)
{
	FILE *fp;
	char quot[MAXQUOT], nam[MAXNAME];
	int i, val;
	
	if((fp = fopen(file, "r")) == NULL)
	{
		printf("\nErro: Impossibilidade em abrir o ficheiro\n");
		exit_program(-1);
	}
	
	flushin(fp);

	i=1;
	
	while((val = getquot(fp, quot))!=-1)
	{
		if(val != 0)
			if((fscanf(fp, " %[^\n]", nam)!=0))
			{
				transl_f2c(quot, MAXQUOT);
				transl_f2c(nam, MAXNAME);
			
				printf("\n\n%d)\n\t%s\n%s", i, quot, nam);
				i++;
				
				if(i%ENTRPTAB==0)
				{
					printf("\n\n\n\tPrima Enter para continuar...\n\n");
					
					getchar();
				}
			}
	}
	
	fflush(fp);	
	fclose(fp);
}

quote find_entryH(char *file, int entry)
{
	FILE *fp;
	int val, i;
	boolean found;
	char quot[MAXQUOT], nam[MAXNAME];
	quote quo;

	
	if((fp=fopen(file, "r")) == NULL)
	{
		printf("Erro: Impossibilidade em abrir o ficheiro\n");
		exit_program(-1);
	}
	
	flushin(fp);
	
	found = FALSE;
	
	for(i=1; (val = getquot(fp, quot))!=-1 && found == FALSE; i++)
	{
		if(val != 0)
		{	
			fscanf(fp, " %[^\n]", nam);

			if(i=entry)
			{
				strcpy(quo.quot, quot);
				strcpy(quo.name, nam);
				
				found = TRUE;
			}
		}
	}
	
	if(found == FALSE)
	{
		quo.quot[0] = '\0';
		quo.name[0] = '\0';
	}

	fflush(fp);
	fclose(fp);
	
	return(quo);
}

void recov_quot()
{
	FILE *fd;
	quote quo;
	int x;
	char cita[MAXQUOT], nome[MAXNAME];
	
	system("cls");
	
	printf("\n\n\bRecuperar cita\x87\xC6o (introduza 0 para cancelar)");
	
	printf("\n\nLista de entradas eliminadas...");
	
	show_list(DELF);
	
	printf("\n\n\nN\xA3mero da entrada: ");
	scanf("%d", &x);
	
	if(x!=0)
	{
	/*******************************************/	
	
		quo = find_entryH(DELF, x);
/*	
		printf("\n\ncitacao: %s\nnome: %s\n\n", quo.quot, quo.name);
		getchar();
*/	
		if(quo.name[0]!='\0')
		{
			strcpy(cita, quo.quot);
			strcpy(nome, quo.name);
		
			transl_f2c(cita, MAXQUOT);
			transl_f2c(nome, MAXNAME);
/*		
			printf("\n\ncitacao: %s\nnome: %s\n\n", cita, nome);
			getchar();
*/		
			add_entry(cita, nome);
/*		
			printf("\n\ncitacao: %s\nnome: %s\n\n", quo.quot, quo.name);
			getchar();
*/		}
	
		else
			printf("\n\nErro: Entrada inv\xA0lida");
	}
	
	else
		printf("\n\nOpera\x87\xC6o cancelada.");
}

void del_quot()
{
	FILE *fd;
	quote quo;
	int x;
	char cita[MAXQUOT], nome[MAXNAME];
	
	system("cls");
	
	printf("\n\n\bRecuperar cita\x87\xC6o (introduza 0 para cancelar)");
	
	printf("\n\nLista de entradas adicionadas...");
	
	show_list(ADDF);
	
	printf("\n\n\nN\xA3mero da entrada: ");
	scanf("%d", &x);
	
	if(x !=0)
	{
	
		quo = find_entryH(ADDF, x);
	
		if(quo.name[0]!='\0')
		{
			strcpy(cita, quo.quot);
			strcpy(nome, quo.name);
		
			transl_f2c(cita, MAXQUOT);
			transl_f2c(nome, MAXNAME);
		
			delete_entry(cita, nome);
		}
	
		else
			printf("\n\nErro: Entrada inv\xA0lida");
	}
	
	else
		printf("\n\nOpera\x87\xC6o cancelada.");
}


void history()
{	
	int op;

//	flushin(stdin);
	
	do
	{	
		system("cls");
	
		list_hist();
		
		system("cls");
		
		if(Nadd != 0 || Ndele !=0)
		{
			printf("\n\n\t0)Sair do programa\n\t1)Retornar ao menu anterior\n\n\t2)Deseja recuperar alguma cita\x87\xC6o eliminada?\n\t3)Eliminar alguma cita\x87\xC6o adicionada?\n\n\nOp\x87\xC6o: ");
			scanf(" %d",&op);
	
			switch(op)
			{
				case 0: exit_program(0);
					break;
				
				case 2: recov_quot();
					break;
				
				case 3: del_quot();
					break;
			}
		}
		
		else
		{
			printf("\n\t1)Retornar ao menu anterior\n\t0)Sair do programa\n\nOp\x87\xC6o: ");
			scanf(" %d",&op);
			
			if(op==0)
				exit_program(0);
		}
	}
	while(op!=1);
}


void make_copy()
{
	FILE *fpf, *fpd, *fpaux;
	int n;
	char str1[MAXQUOT], str2[MAXQUOT], op, data[MAXDAT];
	time_t t;
	
	system("cls");
	
	if((fpaux = fopen(AUXF, "r")) == NULL)
		strcpy(data, "Nunca");
		
	else
		fscanf(fpaux, "%[^\n]", data);
		
	fflush(fpaux);
	fclose(fpaux);
	
	printf("Data da \xA3ltima c\xA2pia: %s\n\nDeseja criar uma nova c\xA2pia de seguran\x87%c do ficheiro de cita\x87\xE4%s?(S/N)\n\n\nop: ", data, 'a', "es"); 
	
	scanf("%c", &op);
	
	if(op=='S' || op == 's')
	{
		time(&t);
		
		if((fpaux = fopen(AUXF, "w"))==NULL)
		{
			printf("Erro na abertura do ficheiro auxiliar\n");
			exit_program(-1);
		}
		
		fprintf(fpaux, "%s\n", ctime(&t));
		
		fflush(fpaux);
		fclose(fpaux);
	
		printf("\n\nA preparar para criar c\xA2pia do original.");
	
		fpf = fopen(FICH, "r");
		fpd = fopen(COPY, "w");
	
		printf("\n\nA fazer c\xA2pia.");
	
		fscanf(fpf, " %[^\n]", str1);
		fprintf(fpd, "%s", str1);
	
		while(getquot(fpf, str1)!=-1 && fscanf(fpf, " %[^\n]", str2)!=EOF)
		{
			fprintf(fpd, "\n\n%s\n", str1);
			fprintf(fpd, "%s", str2);
		}

		printf("\n\nC\xA2pia criada!\n\n");	
		
		fflush(fpd);

		fclose(fpf);
		fclose(fpd);
	}
	
	else
		printf("\n\nC\xA2pia cancelada.\n\n");
	
	getchar();
	getchar();
}

void recover_copy()
{
	char op;

	printf("Deseja recuperar o original apartir da c\xA2pia? (S/N)\n\nOp\x87\xC6o: ");
	scanf("%c", &op);
	
	if(op == 'S' || op == 's')
	{
		remove(FICH);
		rename(COPY, FICH);
	
		printf("\n\nFicheiro recuperado!\n\n\n");
		getchar();
	
		make_copy();
	}
	
	else
	{
		printf("\n\nO ficheiro n\xC6o foi recuperado.\n");	
		getchar();
	}
}

void urgent_recovery()
{
	char op;
	FILE *fp;

	printf("Deseja recuperar a \xA3ltima vers\xC6o v\xA0lida do ficheiro de cita\x87\xE4%s? (S/N)\n\nOp\x87\xC6o: ", "es");
	scanf("%c", &op);
	
	if((fp=fopen(TCOPY, "r"))!=NULL)
	{
		fflush(fp);
		fclose(fp);
	
		if(op == 'S' || op == 's')
		{
			remove(FICH);
			rename(TCOPY, FICH);
	
			printf("\n\nFicheiro recuperado!\n\n\n");
			getchar();
	
			make_copy();
		}
		
		else
		{
			printf("\n\nO ficheiro n\xC6o foi recuperado.\n");	
			getchar();
		}
	}
	
	else
		printf("N\xC6o existe nenhuma vers\xC6o anterior da base de dados.\n\n");
}

void mem_check()
{
	FILE *fp;
	int n, val;
	char quot[MAXQUOT], name[MAXNAME];

	if((fp = fopen(FICH, "r+")) == NULL)
	{
		printf("\nErro: Impossibilidade em abrir o ficheiro\n");
		exit_program(-1);
	}
	
	n=0;
	
	fscanf(fp, " %[^\n]", quot);
	
	while((val = getquot(fp, quot))!=-1)		
		if(val != 0)				
			if((fscanf(fp, " %[^\n]", name)!=0))
				n++;			
				
	printf("\nExistem em mem\xA2ria %d cita\x87\xE4%s.\n", n, "es");
	
	getchar();
}

void about_author()
{
	printf("\n\nO programa find6 foi feito por Jeust (2008).\n\n\n\tEspero que o uses bem. :p\n");
	
	getchar();
}

int menu()
{
	int op;

	system("cls");
	
	printf("\tMenu Principal\n\n\t1)Adicionar entrada\n\t2)Procurar entradas\n\t3)Eliminar entrada\n\t4)Substituir entrada\n\n\n\t5)Hist\xA2ria da Sess\xC6o Actual\n\n\n\t6)Criar uma c\xA2pia do ficheiro de cita\x87\xE4%s\n\t7)Recuperar original apartir da c\xA2pia\n\n\t8)Recupera\x87\xC6o urgente do ficheiro de cita\x87\xE4%s\n\n\t9)Teste de mem\xA2ria\n\t10)Sobre o autor...\n\n\n\t0)Sair\n\n\nOp\x87\xC6o: ", "es", "es");
	scanf(" %d",&op);
	
	system("cls");
	
	return(op);
}

int menu2()
{
	int op;
	
	system("cls");
	
	printf("\n\nPara continuar prima 1\nPara voltar ao menu anterior prima 2\nPara sair introduzir 0\n\n\nOp\x87\xC6o: ");
	scanf(" %d",&op);
	
	system("cls");	
	
	return(op);
}

int main()
{
	int op;
	
	Nadd = 0;
	Ndele = 0;
	
	do
	{
		op = menu();
		
		flushin(stdin);
		
		switch(op)
		{
			case 1: add_entries();
					break;
					
			case 2: list_entries();
					break;
					
			case 3: erase_entry();
					break;
					
			case 4: alter_entry();
					break;
					
			case 5: history();
					break;
					
			case 6: make_copy();
					break;
					
			case 7: recover_copy();
					break;
					
			case 8: urgent_recovery();
					break;
			
			case 9: mem_check();
					break;
					
			case 10: about_author();
					break;
					
			case 11: lookfor_entry();
					break;
		}
	}
	while(op!=0);

	exit_program(0);
}
